/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DbAttributeType;
import ibm.nways.jdm.database.DbInvalidValueTypeException;
import ibm.nways.jdm.database.DbValue;
import ibm.nways.jdm.database.jdbc.DbJdbcColumnType;
import ibm.nways.jdm.database.jdbc.DbJdbcSearch;
import ibm.nways.jdm.database.jdbc.DbJdbcValueRange;
import ibm.nways.jdm.database.jdbc.DbJdbcValueSet;
import java.io.Serializable;

public class DbJdbcValue
extends DbValue
implements Serializable {
    static final int SIMPLE = 0;
    static final int SEARCH = 1;
    static final int SET = 2;
    static final int RANGE = 3;
    private DbJdbcColumnType type;
    private int construct;

    public DbJdbcValue(Object object) throws DbInvalidValueTypeException {
        if (object == null) {
            this.initialize(null, new DbJdbcColumnType(), 0);
            return;
        }
        if (object instanceof String) {
            this.initialize(object, new DbJdbcColumnType(1), 0);
            return;
        }
        if (object instanceof Integer) {
            this.initialize(object, new DbJdbcColumnType(2), 0);
            return;
        }
        if (object instanceof Double) {
            this.initialize(object, new DbJdbcColumnType(3), 0);
            return;
        }
        if (object instanceof DbJdbcSearch) {
            this.initialize(object, null, 1);
            return;
        }
        if (object instanceof DbJdbcValueSet) {
            this.initialize(object, ((DbJdbcValueSet)object).getType(), 2);
            return;
        }
        if (object instanceof DbJdbcValueRange) {
            this.initialize(object, ((DbJdbcValueRange)object).getType(), 3);
            return;
        }
        throw new DbInvalidValueTypeException(this);
    }

    private void initialize(Object object, DbJdbcColumnType dbJdbcColumnType, int n) {
        this.setValue(object);
        this.type = dbJdbcColumnType;
        this.construct = n;
    }

    public DbAttributeType getType() {
        return this.type;
    }

    public DbJdbcColumnType getColumnType() {
        return this.type;
    }

    int getConstruct() {
        return this.construct;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value == null) {
            stringBuffer.append("NULL");
        } else {
            switch (this.construct) {
                case 0: {
                    if (this.type.getType() == 1) {
                        stringBuffer.append("'").append((String)this.value).append("'");
                        break;
                    }
                    stringBuffer.append(this.value.toString());
                    break;
                }
                case 2: 
                case 3: {
                    stringBuffer.append(this.value.toString());
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }
}

